/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.command;

import java.util.ArrayList;
import java.util.List;
import lotr.common.util.LOTRPlayerMoneyData;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;

public class CommandTransferBalance
extends CommandBase {
    public String func_71517_b() {
        return "transfercoin";
    }

    public String func_71518_a(ICommandSender sender) {
        return StatCollector.func_74838_a((String)"transferbalance.usage");
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        int amount;
        if (args.length != 2) {
            throw new WrongUsageException(StatCollector.func_74838_a((String)"transferbalance.usage"), new Object[0]);
        }
        String recipientName = args[0];
        try {
            amount = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            throw new WrongUsageException(StatCollector.func_74838_a((String)"transferbalance.invalidAmount"), new Object[0]);
        }
        EntityPlayerMP senderPlayer = (EntityPlayerMP)sender;
        EntityPlayerMP recipientPlayer = this.getPlayerByName(recipientName);
        if (recipientPlayer == null) {
            ChatComponentText message = new ChatComponentText(String.format(StatCollector.func_74838_a((String)"transferbalance.playerNotFound"), recipientName));
            message.func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED));
            sender.func_145747_a((IChatComponent)message);
            return;
        }
        if (senderPlayer.func_70005_c_().equalsIgnoreCase(recipientName)) {
            ChatComponentText message = new ChatComponentText(StatCollector.func_74838_a((String)"transferbalance.selfTransferError"));
            message.func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED));
            sender.func_145747_a((IChatComponent)message);
            return;
        }
        LOTRPlayerMoneyData senderData = LOTRPlayerMoneyData.of((EntityPlayer)senderPlayer);
        if (senderData.money < amount) {
            ChatComponentText message = new ChatComponentText(String.format(StatCollector.func_74838_a((String)"transferbalance.insufficientFunds"), amount));
            message.func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED));
            sender.func_145747_a((IChatComponent)message);
            return;
        }
        senderData.setMoney(senderData.money - amount, (EntityPlayer)senderPlayer);
        LOTRPlayerMoneyData recipientData = LOTRPlayerMoneyData.of((EntityPlayer)recipientPlayer);
        recipientData.setMoney(recipientData.money + amount, (EntityPlayer)recipientPlayer);
        ChatComponentText successMessage = new ChatComponentText(String.format(StatCollector.func_74838_a((String)"transferbalance.success"), amount, senderPlayer.func_70005_c_(), recipientName));
        successMessage.func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GREEN));
        sender.func_145747_a((IChatComponent)successMessage);
    }

    private EntityPlayerMP getPlayerByName(String playerName) {
        MinecraftServer server = MinecraftServer.func_71276_C();
        for (Object obj : server.func_71203_ab().field_72404_b) {
            EntityPlayerMP player;
            if (!(obj instanceof EntityPlayerMP) || !(player = (EntityPlayerMP)obj).func_70005_c_().equalsIgnoreCase(playerName)) continue;
            return player;
        }
        return null;
    }

    public int func_82362_a() {
        return 0;
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            ArrayList<String> playerNames = new ArrayList<String>();
            for (Object obj : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
                if (!(obj instanceof EntityPlayerMP)) continue;
                playerNames.add(((EntityPlayerMP)obj).func_70005_c_());
            }
            return CommandTransferBalance.func_71530_a((String[])args, (String[])playerNames.toArray(new String[0]));
        }
        return null;
    }
}

